export const PRICES = {
  // 1.
  bauantrag: 5900,
  kfw: 79, // per m²
  soilReport: 1750,
  surveying: 1500,
  crane: 2500, // Neu: Pauschale für Kran
  fund: { 
      streifen_ungedaemmt: 140, streifen_gedaemmt: 170, 
      platte_ungedaemmt: 125, platte_gedaemmt: 150 
  },
  // 2. HAUS
  // Außenwände (Basispreise)
  wallExterior: { '15': 515, '17': 590, '20': 710 },
  // Innenwände (Faktoren / Aufschläge / Rabatte auf einen Basiswert)
  // Wir nehmen an, Innenwände sind im Basispreis enthalten, aber die Dicke ändert den Preis.
  // Logik hier: 15cm ist Standard (Faktor 1.0 oder +0€). 
  // 12cm = Rabatt, 17cm = Aufschlag.
  // Wir definieren hier Auf- und Abschläge pro m² Wohnfläche für die Innenwände.
  // Annahme: ca 0.8m Innenwand pro m² Wohnfläche * Preisdifferenz
  // Vereinfachung: Pauschale Zu/Abschläge pro m² Wohnfläche
  innerWallSurcharge: { 
    '12': -49.50, // Rabatt pro m² Wohnfläche (Erhöht um 200%: von 16.50 auf 49.50)
    '15': 0,      // Standard
    '20': 75      // Aufschlag pro m² Wohnfläche (Erhöht für 20cm Wandstärke)
  },

  height: 1.50, // per cm per m² Aufschlag
  roof: { flat: 75, sattel: 90, pult: 90 },
  facade: { wpc: 27, putz: 37, wdvs: 37, wood: 45 },

  // 3.
  win: { pano: 210, std: 235, shutter: 90 },
  // Aufschlag für Alu (+9%)
  winMaterialFactor: { plastic: 1.0, alu: 1.09 },
  
  door: { out: 950, in: 135, glassKst: 190, glassAlu: 280 },
  // 4.
  dry: { gips: 49, lehm: 70 },
  paint: { std: 25, factor: 1.1 },
  floor: { vinyl: 14, laminat: 29, parkett: 47, fliesen: 35 },
  trittschall: 5,
  elec: { socket: 9, lightStd: 50, lightSpot: 40, lan: 11, smoke: 20, fuse: 390 },
  // 5.
  ac: 310,
  heatFloor: { el: 40, wa: 70 },
  heatPump: 2000, // per kW
  pvPrep: 450,
  pvSystem: { '5kw': 7500, '10kw': 11500 }, // Neu
  batteryStorage: { '5kwh': 1450, '10kwh': 2500 }, // Neu
  water: {
      boiler: { '80': 1000, '100': 1160, '120': 1320, '150': 1520, '200': 1800, '250': 2100, '300': 2400 },
      flow: { '3.5': 600, '6': 800, '8': 1000, '12': 1180, '16': 1400, '21': 1540, '24': 1800 }
  },
  sanitary: { wc: 149, sink: 110, shower: 170, tub: 190, tap: 70 },
  // 6.
  terrace: 35, // m²
  garage: 470, // st
  stair: { out: 2350, in: 2700 }
};

export const WATER_BOILER_OPTIONS = [80, 100, 120, 150, 200, 250, 300];
export const WATER_FLOW_OPTIONS = ["3.5", "6", "8", "12", "16", "21", "24"];