import React from 'react';

interface RoofPreviewProps {
  roof: string;
  facade: string;
}

const RoofPreview: React.FC<RoofPreviewProps> = ({ roof, facade }) => {
  let fill = "#f5f5f5";
  let stroke = "#444";

  if (facade === 'wpc') fill = "#b0b0b0";
  if (facade === 'wood') fill = "#d2691e";
  if (facade === 'putz' || facade === 'wdvs') fill = "#ffffff";
  if (facade === 'none') { fill = "#e5e7eb"; stroke = "#9ca3af"; }

  const renderRoof = () => {
    switch (roof) {
      case 'none': // Free version (Base roof)
      case 'flat': // Paid version (Flat roof, visually similar to base)
        return <rect x="23" y="42" width="54" height="4" fill="#333" />;
      case 'sattel': return <polygon points="23,45 50,20 77,45" fill="#333" />;
      case 'pult': return <polygon points="23,45 77,30 77,45" fill="#333" />;
      default: return null;
    }
  };

  return (
    <div className="w-full h-[130px] flex justify-center items-center">
      <svg viewBox="0 0 100 100" className="w-full h-full">
        {/* Base House */}
        <rect x="25" y="45" width="50" height="40" fill={fill} stroke={stroke} strokeWidth="1.5" />
        
        {/* Roof */}
        {renderRoof()}

        {/* Windows */}
        <rect x="32" y="55" width="12" height="15" fill="#bae6fd" stroke="#555" strokeWidth="1" />
        <rect x="56" y="55" width="12" height="15" fill="#bae6fd" stroke="#555" strokeWidth="1" />
      </svg>
    </div>
  );
};

export default RoofPreview;
