import React from 'react';
import { formatCurrency } from '../utils';

interface MobileActionbarProps {
  netto: number;
  onOpen: () => void;
}

const MobileActionbar: React.FC<MobileActionbarProps> = ({ netto, onOpen }) => {
  return (
    <div className="lg:hidden fixed bottom-0 left-0 right-0 bg-white/95 backdrop-blur-md p-4 z-50 border-t border-gray-200 flex justify-between items-center shadow-[0_-5px_25px_rgba(0,0,0,0.1)] pb-safe">
       <div>
          <span className="text-[10px] block uppercase tracking-wider text-gray-500 font-semibold">Gesamt (Netto)</span>
          <span className="font-serif font-bold text-xl text-primary">{formatCurrency(netto)}</span>
       </div>
       <button 
          onClick={onOpen}
          className="bg-primary text-accent border border-primary py-3 px-6 rounded-full text-sm font-bold tracking-wide hover:bg-accent hover:text-white transition-all shadow-lg active:scale-95 flex items-center gap-2"
       >
          <i className="fas fa-file-pdf"></i> PDF Laden
       </button>
    </div>
  );
};

export default MobileActionbar;