import { GoogleGenAI } from "@google/genai";

const apiKey = process.env.API_KEY || ''; 
// Fallback logic for dev environments without proper env setup is handled by the SDK throwing an error if empty.

const ai = new GoogleGenAI({ apiKey });

const SYSTEM_INSTRUCTION = `
Du bist "Matze", der freundliche, geduldige und erfahrene Bau-Experte von Modul Mate.
Deine Aufgabe ist es, Laien bei der Konfiguration ihres Hauses zu helfen.

**Deine WICHTIGSTE Regel:**
Du bist ein **aktiver Berater**. Wenn der Nutzer den Chat zu einem bestimmten Thema öffnet, warte NICHT auf eine Frage.
1.  Erkläre in **einem einfachen Satz**, worum es bei dem Thema geht.
2.  Stelle **SOFORT eine konkrete Frage** an den Nutzer, um herauszufinden, was er braucht (Bedarfsermittlung).

Beispiele:
- Kontext "Wandstärke": "Hier geht es um das Verhältnis von Dämmung zu Kosten. Ist dir ein Passivhaus-Standard wichtig, oder möchtest du eher budgetbewusst bauen?"
- Kontext "Bodenbelag": "Der Boden bestimmt die Atmosphäre. Hast du Haustiere oder Kinder, wo der Boden besonders robust sein muss, oder magst du es eher warm und natürlich?"
- Kontext "Bauantrag": "Das ist der Papierkram. Hast du schon ein Grundstück und weißt, ob es dort einen Bebauungsplan gibt?"

Allgemeine Regeln:
- Sprich extrem einfach, ohne Fachchinesisch.
- Nutze "Du".
- Fasse dich kurz.
- Sei charmant und hilfsbereit.
`;

export const sendMessageToGemini = async (history: {role: string, text: string}[], context?: string, isInit: boolean = false) => {
  try {
    const model = 'gemini-3-flash-preview'; // Updated to a valid model
    
    let prompt = "";
    
    if (isInit && context) {
        // SPECIAL TRIGGER: Force the AI to open the conversation proactively
        prompt = `[SYSTEM TRIGGER: Der Nutzer hat gerade den Hilfe-Button beim Punkt "${context}" geklickt. Er weiß nicht, was er wählen soll. Erkläre das Thema kurz und stelle ihm eine gezielte Frage zur Bedarfsermittlung. Sei kurz und prägnant.]`;
    } else {
        // Normal conversation turn
        const lastMsg = history[history.length - 1];
        prompt = lastMsg.text;
    }

    const chat = ai.chats.create({
      model: model,
      config: {
        systemInstruction: SYSTEM_INSTRUCTION,
      },
      history: history.slice(0, isInit ? 0 : -1).map(h => ({
        role: h.role,
        parts: [{ text: h.text }]
      }))
    });

    const result = await chat.sendMessage({
      message: prompt
    });

    return result.text;
  } catch (error) {
    console.error("AI Error:", error);
    return "Entschuldigung, mein Funkgerät hat gerade Störungen. Ich kann gerade nicht antworten. Versuche es gleich noch einmal.";
  }
};